<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\{
    FromArray,
    WithStyles,
    WithColumnWidths,
    ShouldAutoSize
};
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class FormInstanceSingleSheetExport implements FromArray, WithStyles, WithColumnWidths, ShouldAutoSize
{
    protected $instance;

    public function __construct(array $data)
    {
        $this->instance = $data['instance'];
    }

    public function array(): array
    {
        $rows = [];

        /* =============================
         | REPORT HEADER
         ============================= */
        $rows[] = ['Compliance Report'];
        $rows[] = ['Form', $this->instance->template->form_name];
        $rows[] = ['State', $this->instance->template->state_master?->name];
        $rows[] = ['Generated At', now()->format('d M Y H:i')];
        $rows[] = [];

        /* =============================
         | FORM DETAILS
         ============================= */
        $rows[] = ['Form Details'];
        $rows[] = ['Field', 'Value'];

        foreach ($this->instance->template->fields as $field) {
            $value = $this->instance->values
                ->firstWhere('form_field_id', $field->id);

            $rows[] = [
                $field->field_label,
                $value?->field_value ?? '',
            ];
        }

        $rows[] = [];
        $rows[] = ['Statutory Compliance Details'];
        $rows[] = [
            'Act',
            'Section',
            'Form',

            'Status',
            'Remarks',
        ];

        /* =============================
         | COMPLIANCE TABLE
         ============================= */
        foreach ($this->instance->actSections as $row) {
            $rows[] = [
                $row->statutoryAct?->act_name,
                $row->statutorySection?->section,
                $row->statutorySection?->form,

                $row->status,
                $row->remarks,
            ];
        }

        return $rows;
    }

    public function styles(Worksheet $sheet)
    {
        return [
            1  => ['font' => ['bold' => true, 'size' => 14]],
            6  => ['font' => ['bold' => true]],
            7  => ['font' => ['bold' => true]],
            10 => ['font' => ['bold' => true]],
            11 => ['font' => ['bold' => true]],
        ];
    }

    public function columnWidths(): array
    {
        return [
            'A' => 30,
            'B' => 25,
            'C' => 20,
            'D' => 25,
            'E' => 18,
            'F' => 30,
            'G' => 35,
        ];
    }
}
