<?php

use App\Models\User;
use PHPOpenSourceSaver\JWTAuth\Facades\JWTAuth;

if (!function_exists('current_user')) {
    function current_user(): ?User
    {
        try {
            return JWTAuth::parseToken()->authenticate();
        } catch (\Throwable $e) {
            return null;
        }
    }
}

if (!function_exists('current_user_has_role')) {
    function current_user_has_role(string $role): bool
    {
        $user = current_user();
        return $user && $user->role && strtolower($user->role->name) === strtolower($role);
    }
}
