<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\CityMaster;
use App\Models\ClientClassificationMaster;
use App\Models\ClientDepartmentMaster;
use App\Models\ClientSourceMaster;
use App\Models\KeyAreasComplianceMaster;
use App\Models\NatureComplianceMaster;
use App\Models\RoleMaster;
use App\Models\StateMaster;
use App\Models\SubmissionAuthorityMaster;
use App\Traits\ApiResponseTrait;

class MasterController extends Controller
{
    use ApiResponseTrait;

    /**
     * City Master
     */
    public function getCities()
    {
        $data = CityMaster::orderBy('name')->get();
        return $this->successResponse("City master fetched successfully", $data);
    }

    public function getCitiesByStateId($id)
    {
        $data = CityMaster::where('state_id',$id)->orderBy('name')->get();
        return $this->successResponse("City master fetched successfully", $data);
    }

    /**
     * Client Department Master
     */
    public function getClientDepartments()
    {
        $data = ClientDepartmentMaster::orderBy('name')->get();
        return $this->successResponse("Client department master fetched successfully", $data);
    }

    /**
     * Client Source Master
     */
    public function getClientSources()
    {
        $data = ClientSourceMaster::orderBy('name')->get();
        return $this->successResponse("Client source master fetched successfully", $data);
    }

    /**
     * Client Classification Master
     */
    public function getClientClassification()
    {
        $data = ClientClassificationMaster::orderBy('name')->get();
        return $this->successResponse("Client classification master fetched successfully", $data);
    }

    /**
     * Role Master
     */
    public function getRoles()
    {
        $data = RoleMaster::orderBy('name')->get();
        return $this->successResponse("Role master fetched successfully", $data);
    }

    /**
     * State Master
     */
    public function getStates()
    {
        $data = StateMaster::orderBy('name')->get();
        return $this->successResponse("State master fetched successfully", $data);
    }

    public function getNatureCompliance()
    {
        $data = NatureComplianceMaster::orderBy('name')->get();
        return $this->successResponse("Nature compliance master fetched successfully", $data);
    }

    public function getSubmissionAuthority()
    {
        $data = SubmissionAuthorityMaster::orderBy('authority_name')->get();
        return $this->successResponse("Submission Authority master fetched successfully", $data);
    }

    public function getKeyAreasComplianceMaster()
    {
        $data = KeyAreasComplianceMaster::orderBy('name')->get();
        return $this->successResponse("Key Area Compliance master fetched successfully", $data);
    }
}
