<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use App\Services\StatutoryDueDateService;

class TestController extends Controller
{
    public function testEmail()
    {
        try {
            Mail::raw('This is a test email sent via Hostinger SMTP.', function ($message) {
                $message->to('swamirdeie@gmail.com')
                        ->subject('Laravel Hostinger SMTP Test');
            });

            return response()->json([
                'status' => true,
                'message' => 'Test email sent successfully! Check your inbox or spam.'
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'status' => false,
                'message' => 'Email sending failed.',
                'error' => $e->getMessage()
            ]);
        }
    }

    public function generateDueDates()
    {
        (new StatutoryDueDateService())->processAll();
        return response()->json(['message' => 'Due dates generated']);
    }
}
