<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class FormInstanceActAttachment extends Model
{
     protected $table = 'form_instance_act_attachment';

     protected $fillable = [
        'form_instance_act_section_id','attachment_name','attachment_path',
    ];

    const CREATED_AT = 'created_on';
    const UPDATED_AT = 'updated_on';
    public $timestamps = true;

    public function actSection()
    {
        return $this->belongsTo(
            FormInstanceActSection::class,
            'form_instance_act_section_id'
        );
    }

}

