<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Model;

class FormInstanceActSection extends Model
{
    protected $table = 'form_instance_act_sections';

    protected $fillable = [
        'form_instance_id','act_id','sections_id',
        'remarks','status','attachment_id'
    ];

    const CREATED_AT = 'created_on';
    const UPDATED_AT = 'updated_on';
    public $timestamps = true;

    public function formInstance()
    {
        return $this->belongsTo(FormInstance::class, 'form_instance_id');
    }

    public function statutoryAct()
    {
        return $this->belongsTo(StatutoryMaster::class, 'act_id');
    }

    public function statutorySection()
    {
        return $this->belongsTo(StatutorySections::class, 'sections_id');
    }

    public function attachments()
    {
        return $this->hasMany(FormInstanceActAttachment::class, 'form_instance_act_section_id');
    }

}
