<?php

namespace App\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Contracts\Auth\CanResetPassword;
use Illuminate\Auth\Passwords\CanResetPassword as CanResetPasswordTrait;

class UserAuth extends Authenticatable implements CanResetPassword
{
    use CanResetPasswordTrait;

    protected $table = 'user_auth';

    protected $fillable = ['email', 'username', 'password', 'is_active', 'reset_token', 'token_expires_on'];

    // Use custom timestamps
    const CREATED_AT = 'created_on';
    const UPDATED_AT = 'updated_on';
    public $timestamps = true;
}
