<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Database\Eloquent\Model;
use App\Observers\UserActionObserver;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        foreach ([
            \App\Models\ClientMaster::class,
            \App\Models\Office::class,
            \App\Models\User::class,
            \App\Models\UserAuth::class,
            \App\Models\ClientDepartmentMaster::class,
            \App\Models\ClientSourceMaster::class,
            \App\Models\ClientBranch::class,
            \App\Models\ClientBranchSystemUsermaping::class,
            \App\Models\StatutoryMaster::class,
            \App\Models\ComplianceMaster::class,
            \App\Models\OfficeClientBranchMapping::class,
            \App\Models\UserDeleteLog::class,
            \App\Models\FormTemplate::class,
            \App\Models\FormField::class,
            \App\Models\FormActivityLog::class,
            \App\Models\FormInstance::class,
            \App\Models\FormInstanceValue::class,
            \App\Models\FormWorkflow::class,
            \App\Models\KeyAreasComplianceMaster::class,
            \App\Models\KeyAreaSubCompliance::class,
            \App\Models\StatutorySections::class,
            \App\Models\FormTemplateStatutoryAct::class,
            \App\Models\Team::class,
            \App\Models\TeamUsersMapping::class,
            \App\Models\Task::class,

        ] as $model) {
            $model::observe(\App\Observers\UserActionObserver::class);
        }
    }

}
