<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Compliance Report</title>

    <style>
      body {
        font-family: "DejaVu Sans", "Helvetica", "Arial", sans-serif;
        font-size: 12px;
        color: #111827;
        line-height: 1.5;
      }

      h2 {
        font-size: 18px;
        font-weight: 700;
      }

      h3 {
        font-size: 14px;
        font-weight: 600;
      }

      .muted {
        color: #6b7280;
        font-size: 11px;
      }

      .card {
        border: 1px solid #e5e7eb;
        border-radius: 6px;
        padding: 12px;
        margin-top: 16px;
      }

      table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 6px;
      }

      th, td {
        border: 1px solid #e5e7eb;
        padding: 6px 8px;
        vertical-align: top;
      }

      th {
        background: #f9fafb;
        font-weight: 600;
        font-size: 11px;
      }

      .label-cell {
        width: 40%;
        background: #f9fafb;
        font-weight: 600;
      }

      /* ===== STATUS CHIP ===== */
      .chip {
        display: inline-block;
        padding: 3px 8px;
        border-radius: 12px;
        font-size: 11px;
        font-weight: 600;
        color: #fff;
        white-space: nowrap;
      }

      .COMPLIED { background: #16a34a; }
      .NOT\ COMPLIED { background: #dc2626; }
      .OUT\ OF\ SCOPE { background: #2563eb; }
      .YET\ TO\ ASCERTAIN { background: #d97706; }
      .NOT\ APPLICABLE { background: #6b7280; }

      /* ===== OVERALL STATUS ===== */
      .status-row { margin-bottom: 8px; }

      .status-header {
        display: flex;
        justify-content: space-between;
        font-size: 11px;
        margin-bottom: 2px;
      }

      .progress {
        height: 6px;
        background: #e5e7eb;
        border-radius: 4px;
        overflow: hidden;
      }

      .progress-bar { height: 6px; }

      .progress-COMPLIED { background: #16a34a; }
      .progress-NOT\ COMPLIED { background: #dc2626; }
      .progress-OUT\ OF\ SCOPE { background: #2563eb; }
      .progress-YET\ TO\ ASCERTAIN { background: #d97706; }
      .progress-NOT\ APPLICABLE { background: #6b7280; }

      /* ===== ATTACHMENTS ===== */
      .attachment {
        display: inline-block;
        margin-right: 6px;
        margin-top: 4px;
        font-size: 10px;
        border: 1px solid #d1d5db;
        padding: 2px 6px;
        border-radius: 4px;
      }
    </style>
</head>
<body>

<?php
    $hasCompliances = $instance->actSections && $instance->actSections->count() > 0;
?>


<table width="100%" cellpadding="0" cellspacing="0" style="margin-bottom: 12px; border: none;">
  <tr>
    <td style="background-color: #011960; padding: 12px 14px; border: none;">
      <table width="100%" cellpadding="0" cellspacing="0" style="border: none;">
        <tr>
          <td style="vertical-align: middle; border: none;">
            <h3 style="margin: 0; color: #ffffff;">
              <?php echo e('Establishment Compliance Report - ' . ($instance->template->state_master?->name ?? '-')); ?>

            </h3>
            <div style="color: #c7d2fe; font-size: 11px;">
              Generated: <?php echo e(now()->format('d M Y H:i')); ?>

            </div>
          </td>

          <td style="text-align: right; vertical-align: middle; border: none;">
            <span style="background-color: #ffffff; padding: 6px 10px; border-radius: 4px; display: inline-block;">
              <img src="<?php echo e(public_path('images/vhrLogo.png')); ?>" alt="VHR Logo" style="height: 42px;">
            </span>
          </td>
        </tr>
      </table>
    </td>
  </tr>
</table>


<div class="card">
  <h3>Client Details</h3>

  <?php
    $branchName = $instance->client_branch->branch_name ?? '';
    $branchAddress = $instance->client_branch->address ?? '';
    $branchCity = $instance->client_branch->city_master?->name ?? '';
    $branchState = $instance->client_branch->state_master?->name ?? '';

    $fullAddress = collect([$branchAddress, $branchCity, $branchState])
      ->filter(fn ($v) => filled($v))
      ->join(', ');
  ?>

  <table>
    <tr>
      <td class="label-cell">Branch Name</td>
      <td><?php echo e($branchName ?: '—'); ?></td>
    </tr>

    <tr>
      <td class="label-cell">Address</td>
      <td><?php echo e($fullAddress ?: '—'); ?></td>
    </tr>
  </table>
</div>



<div class="card">
  <h3>Form Details</h3>

  <table>
    <?php $__currentLoopData = $instance->template->fields; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $field): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <?php
        $value = $instance->values->firstWhere('form_field_id', $field->id);
      ?>

      <tr>
        <td class="label-cell"><?php echo e($field->field_label); ?></td>
        <td><?php echo e($value?->field_value ?? '—'); ?></td>
      </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  </table>
</div>


<?php if($hasCompliances): ?>
<div class="card">
  <h3>Statutory Compliance Details</h3>

  <table>
    <thead>
      <tr>
        <th>Act</th>
        <th>Section / Rule</th>
        <th>Form</th>
        <th>Nature of Compliance</th>
        <th>Status</th>
        <th>Remarks</th>
      </tr>
    </thead>
    <tbody>
      <?php $__currentLoopData = $instance->actSections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
          <td><?php echo e($row->statutoryAct?->act_name ?? '-'); ?></td>
          <td><?php echo e($row->statutorySection?->section ?? '-'); ?></td>
          <td><?php echo e($row->statutorySection?->form ?? '-'); ?></td>
          <td><?php echo e($row->statutorySection?->nature_of_compliance ?? '-'); ?></td>

          <td>
            <span class="chip <?php echo e($row->status); ?>"><?php echo e($row->status); ?></span>
          </td>

          <td><?php echo e($row->remarks ?? '—'); ?></td>
        </tr>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
  </table>
</div>
<?php endif; ?>


<?php if($hasCompliances): ?>
<?php
  $statuses = [
    'COMPLIED',
    'NOT COMPLIED',
    'OUT OF SCOPE',
    'YET TO ASCERTAIN',
    'NOT APPLICABLE',
  ];

  $total = max($instance->actSections->count(), 1);
?>

<div class="card">
  <h3>Overall Compliance Status</h3>

  <?php $__currentLoopData = $statuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <?php
      $count = $instance->actSections->where('status', $status)->count();
      $percent = round(($count / $total) * 100);
    ?>

    <div class="status-row">
      <div class="status-header">
        <span><?php echo e(str_replace('_', ' ', $status)); ?></span>
        <span><?php echo e($percent); ?>%</span>
      </div>
      <div class="progress">
        <div class="progress-bar progress-<?php echo e($status); ?>" style="width: <?php echo e($percent); ?>%"></div>
      </div>
    </div>
  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>
<?php endif; ?>



</body>
</html>
<?php /**PATH /Volumes/SpareDrive/YAIMX/Projects/VHR/api/resources/views/reports/form-instance.blade.php ENDPATH**/ ?>