<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromArray;

class FormInstanceReportExport implements FromArray
{
    protected array $data;

    public function __construct(array $data)
    {
        $this->data = $data;
    }

    public function array(): array
    {
        return [
            ['Act', 'Section', 'Form', 'Status', 'Remarks'],
            ...collect($this->data['instance']->actSections)->map(function ($row) {
                return [
                    $row->statutoryAct->act_name ?? '',
                    $row->statutorySection->section_name ?? '',
                    $row->form_no ?? '',
                    $row->status ?? '',
                    $row->remarks ?? '',
                ];
            })->toArray(),
        ];
    }
}
