<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class ForgotPasswordMail extends Mailable
{
    use Queueable, SerializesModels;

    public $token;
    public $email;

    /**
     * Create a new message instance.
     */
    public function __construct($token, $email)
    {
        $this->token = $token;
        $this->email = $email;
    }

    /**
     * Build the message.
     */
    public function build()
    {
        $frontend = rtrim(env('FRONTEND_URL'), '/');

        $resetUrl = "{$frontend}/auth/resetpassword?token={$this->token}&email={$this->email}";

        return $this->subject('Reset Your Password')
                    ->view('emails.forgot_password')
                    ->with([
                        'resetUrl' => $resetUrl,
                        'email'    => $this->email
                    ]);
    }

}
