<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\CityMaster;
use App\Models\StateMaster;
use App\Models\ClientBranchSystemUsermaping;
use App\Models\User;

class ClientBranch extends Model
{
    protected $table = 'client_branch';

    protected $fillable = [
        'client_id',
        'branch_code',
        'branch_name',
        'address',
        'state_id',
        'city_id',
        'pincode',
        'email',
        'spoc_name',
        'spoc_email',
        'spoc_contact',
        'escalation_name',
        'escalation_email',
        'escalation_contact',
        'effective_month',
        'is_active',
        'is_deleted',
        'created_by',
        'updated_by'
    ];

     // Use custom timestamp fields
    const CREATED_AT = 'created_on';
    const UPDATED_AT = 'updated_on';
    public $timestamps = true;

     public function city_master()
    {
        return $this->belongsTo(CityMaster::class, 'city_id');
    }

    public function state_master()
    {
        return $this->belongsTo(StateMaster::class, 'state_id');
    }

    public function branch_system_user_mapping()
    {
        return $this->hasMany(ClientBranchSystemUsermaping::class, 'branch_id', 'id');
    }

    public function client_branch_users()
    {
        return $this->hasMany(User::class, 'client_branch_id', 'id');
    }

    public function office_client_branch_mapping()
    {
        return $this->hasMany(OfficeClientBranchMapping::class, 'client_branch_id');
    }

}
