<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Model;

class FormInstance extends Model
{
    protected $table = 'form_instance';

    protected $fillable = [
        'form_template_id','client_id','branch_id',
        'period','due_date','current_status',
        'assigned_to','reviewer_id','risk_level'
    ];

    const CREATED_AT = 'created_on';
    const UPDATED_AT = 'updated_on';
    public $timestamps = true;

    public function template()
    {
        return $this->belongsTo(FormTemplate::class, 'form_template_id');
    }

    public function values()
    {
        return $this->hasMany(FormInstanceValue::class);
    }

    public function actSections()
    {
        return $this->hasMany(FormInstanceActSection::class, 'form_instance_id');
    }

    public function client()
    {
        return $this->belongsTo(ClientMaster::class, 'client_id');
    }

    public function client_branch()
    {
        return $this->belongsTo(ClientBranch::class, 'branch_id');
    }

    public function assignee()
    {
        return $this->belongsTo(User::class, 'assigned_to');
    }
}
