<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class FormTemplate extends Model
{
    protected $table = 'form_template';

    protected $fillable = [
        'form_code','form_name','act_name','jurisdiction_type','client_id','client_branch_id',
        'state_id','key_areas_compliance_id','key_areas_sub_compliance_id','periodicity','version','is_active','created_by',
        'updated_by'
    ];

    const CREATED_AT = 'created_on';
    const UPDATED_AT = 'updated_on';
    public $timestamps = true;

   public function fields()
    {
        return $this->hasMany(FormField::class)
            ->orderBy('display_order');
    }

    public function instances()
    {
        return $this->hasMany(FormInstance::class);
    }

    public function workflow() {
        return $this->hasMany(FormWorkflow::class);
    }

    public function key_areas_compliance() {
        return $this->belongsTo(KeyAreasComplianceMaster::class,'key_areas_compliance_id');
    }

    public function key_areas_sub_compliance() {
        return $this->belongsTo(KeyAreaSubCompliance::class,'key_areas_sub_compliance_id');
    }

    public function state_master()
    {
        return $this->belongsTo(StateMaster::class, 'state_id');
    }

    public function statutory_act()
    {
        return $this->hasMany(FormTemplateStatutoryAct::class, 'form_template_id', 'id');
    }

     public function client()
    {
        return $this->belongsTo(ClientMaster::class, 'client_id');
    }

    public function client_branch()
    {
        return $this->belongsTo(ClientBranch::class, 'client_branch_id');
    }
}
