<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class RoleMaster extends Model
{
    protected $table = 'user_role_master';

    protected $fillable = ['name'];

    // Use custom timestamp fields
    const CREATED_AT = 'created_on';
    const UPDATED_AT = 'updated_on';
    public $timestamps = true;

    public function users()
    {
        return $this->hasMany(User::class, 'role_id');
    }
}
