<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Task extends Model
{
    protected $table = 'tasks';

    protected $fillable = [
        'title',
        'description',
        'status',
        'priority',
        'due_date',
        'assigned_to',
        'created_by',
        'updated_by',
        'client_id',
        'client_branch_id',
        'form_compliance_id',
    ];

    // Use custom timestamp fields
    const CREATED_AT = 'created_on';
    const UPDATED_AT = 'updated_on';
    public $timestamps = true;

    /**
     * Get the activities for the task
     */
    public function activities(): HasMany
    {
        return $this->hasMany(TaskActivity::class)->latest();
    }

    /**
     * Get the user assigned to the task
     */
    public function assignedUser(): BelongsTo
    {
        return $this->belongsTo(User::class, 'assigned_to');
    }

    /**
     * Get the user who created the task
     */
    public function createdByUser(): BelongsTo
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    /**
     * Get the client for the task
     */
    public function client(): BelongsTo
    {
        return $this->belongsTo(ClientMaster::class, 'client_id');
    }

    /**
     * Get the client branch for the task
     */
    public function clientBranch(): BelongsTo
    {
        return $this->belongsTo(ClientBranch::class, 'client_branch_id');
    }

    /**
     * Get the form compliance for the task
     */
    // public function formCompliance(): BelongsTo
    // {
    //     return $this->belongsTo(FormCompliance::class, 'form_compliance_id');
    // }
}
