<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class TeamUsersMapping extends Model
{
    protected $table = 'team_users_mapping';

    protected $fillable = [
        'team_id', 'user_id', 'is_active', 'is_deleted'
    ];

    const CREATED_AT = 'created_on';
    const UPDATED_AT = 'updated_on';

    public $timestamps = true;

    protected $casts = [
        'is_active' => 'boolean',
        'is_deleted' => 'boolean',
        'created_on' => 'datetime',
        'updated_on' => 'datetime',
    ];

    /**
     * Get the team
     */
    public function team()
    {
        return $this->belongsTo(Team::class, 'team_id');
    }

    /**
     * Get the user
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}
