<?php

namespace App\Observers;

use Illuminate\Support\Facades\Auth;
use Illuminate\Database\Eloquent\Model;

class UserActionObserver
{
    public function creating(Model $model): void
    {
        if (Auth::check()) {
            $model->created_by = Auth::id();
            $model->updated_by = Auth::id();
        }
    }

    public function updating(Model $model): void
    {
        if (Auth::check()) {
            $model->updated_by = Auth::id();
        }
    }
}
